<?
/*
Author		: Yaw
Version		: 1.01
Date		: 29th March 2002
Function	: Inventory Query

Added by	: Sue
Version		: 1.01
Date		: 1th April 2002
Function	: Image Upload
*/
session_start();
require("auth.php");
unset($msg);
unset($errmsg);
###############################
# Getting quarter information #
###############################
$today = getdate();
$month = $today['mon']; 
$mday = $today['mday']; 
$year = $today['year'];
#######################################################################
# Registering Sort Order into Session so that the page appears in	  #
# the same sorting order everytime the user from the same browser	  #
# access the same page												  #
#######################################################################
// First time the user access the page, automatically sort by group starting range
if (($Transmarco["userquerysort"] == "") && ($sortorder == "")) {
	$Transmarco["userquerysort"] = " order by invgroupcode, invnumber";
}
// Subsequently when users decide on a sorting preference, store their preference into a session
else if (($Transmarco["userquerysort"] != "") && ($sortorder == "Model")) {
	$Transmarco["userquerysort"] = " order by invgroupcode, invnumber";
}
else if (($Transmarco["userquerysort"] != "") && ($sortorder == "Date_Created")) {
	$Transmarco["userquerysort"] = " order by invcreatedtime";
}
else if (($Transmarco["userquerysort"] != "") && ($sortorder == "Supplier")) {
	$Transmarco["userquerysort"] = " order by invsupplier";
}
else if (($Transmarco["userquerysort"] != "") && ($sortorder == "Created_By")) {
	$Transmarco["userquerysort"] = " order by invcreatedbyuser";
}
else if (($Transmarco["userquerysort"] != "") && ($sortorder == "Ref_No")) {
	$Transmarco["userquerysort"] = " order by invrefno";
}
##############################################################################
# Formatting the querysql for users who arrive at this page without adding   #
# any inventory, default search is show all profiles created in same quarter #
##############################################################################
if ($Transmarco["querysql"] == "") {
	if (($month >= 1) and ($month <=3)) {
		$Transmarco["querymsg"] = "All Inventory Profiles Created in Quarter One<br>";
		$Transmarco["querysql"]="select * from inventoryprofile where invcreatedtime>='$year-01-01'" . "and invcreatedtime<='$year-03-31'";
	}
	else if (($month >= 4) and ($month <=6)) {
		$Transmarco["querymsg"] = "All Inventory Profiles Created in Quarter Two<br>";
		$Transmarco["querysql"]="select * from inventoryprofile where invcreatedtime>='$year-04-01'" . "and invcreatedtime<='$year-06-30'";
	}
	else if (($month >= 7) and ($month <=9)) {
		$Transmarco["querymsg"] = "All Inventory Profiles Created in Quarter Three<br>";
		$Transmarco["querysql"]="select * from inventoryprofile where invcreatedtime>='$year-07-01'" . "and invcreatedtime<='$year-09-30'";
	}
	else if (($month >= 10) and ($month <=12)) {
		$Transmarco["querymsg"] = "All Inventory Profiles Created in Quarter Four<br>";
		$Transmarco["querysql"]="select * from inventoryprofile where invcreatedtime>='$year-010-01'" . "and invcreatedtime<='$year-12-31'";
	}
}
##################################
# Locking and Unlocking a Record #
##################################
if ($Transmarco["accesslevel"] == $adminlevel) {
	if ($action == "Lock") {
		$sql = "update inventoryprofile set invlock='Y' where invid=$id";
		db_query($sql);
		$msg = "Inventory Profile Locked<br>";
	}
	if ($action == "Unlock") {
		$sql = "update inventoryprofile set invlock='N' where invid=$id";
		db_query($sql);
		$msg = "Inventory Profile Unlocked<br>";
	}
}
#####################################################
# Editing and Updating an Inventory Profile         #
#####################################################
if ($action == 'Update') {
	// Initializing Msg Text
	$msg = "";
	// Check if the record is locked for editing
	$sql = "select * from inventoryprofile where invid='$id'";
	$result = db_query($sql);
	$row = db_fetch_array($result,$x);
	if ($row["invlock"] != "N"){
		// Record is locked and cannot be edited
		$msg = $msg . "Record has been locked and cannot be edited!<br>";
	} else {
		// Safe to proceed with form field validation
		if (($invsizerange == "") || ($invsupplier == "Select One") || ($invcost == "") || ($invretailprice == "")){
			$msg = $msg . "Blank Data Submitted Into Mandatory Fields<br>";
		}
		if (!ereg ("([0-9])", $invqty)) {
			$msg = $msg . "Invalid Quantity Keyed in<br>";
		}
		if ($msg == "") {
			// No Error messages inserted yet => safe to proceed with database insertion
			$invdesc = magiccode($invdesc);
			$invremarks = magiccode($invremarks);
			$invsizerange = magiccode($invsizerange);
			$supplier = magiccode($supplier);
			$invcost = magiccode($invcost);
			$invdeliverydatetime = magiccode($invdeliverydatetime);
			$invqty = magiccode($invqty);
			$invretailprice = magiccode($invretailprice);
			$invdeliverydatetime = magiccode($invdeliveryyear . "-" . $invdeliverymonth . "-" . $invdeliveryday . " 00:00:00");
			if (strlen($invdeliverymonth) == 2){
				$invrefno = magiccode(substr($invdeliveryyear,3,1)) . $invdeliverymonth;
			} else {
				$invrefno = magiccode(substr($invdeliveryyear,3,1)) . "0" . $invdeliverymonth;
			}
			$sql = "update inventoryprofile set invdesc='$invdesc', invremarks='$invremarks', invsizerange='$invsizerange', invsupplier='$supplier', invcost='$invcost', invdeliverydatetime='$invdeliverydatetime', invrefno='$invrefno', invqty='$invqty', invdeliverydatetime='$invdeliverydatetime', invretailprice='$invretailprice' where invid='$id'";
			db_query($sql);

			// Inserting Colours
			$count=count($invcolor);
			$sql = "delete from colourinv where invid='$id'";
			db_query($sql);
			for ($x=0; $x<$count; $x++) {
				$invcolor[$x] = magiccode($invcolor[$x]);
				$sql = "insert into colourinv values('$id','$invcolor[$x]')";
				db_query($sql);
			}
			$msg = $msg . "Update Successful!";
		} else {
			$msg = $msg . "Update Failed!<br>";
		}
	}
}
#########################################################################################
# Formatting & set the query string into the session if User chooses to customise Query #
#########################################################################################
if ($action == "Query") {
	$Transmarco["querymsg"] = "User Customised Query<br>";
	$Transmarco["querysql"] = "select * from inventoryprofile ";
	########################################
	# Cleaning session variables if needed #
	########################################
	if ($group == ""){
		unset($Transmarco["querygroup"]);
	}
	if ($supplier == ""){
		unset($Transmarco["querysupplier"]);
	}
	if ($ref == ""){
		unset($Transmarco["queryref"]);
	}
	if ($stylestartingrange == ""){
		unset($Transmarco["querystart"]);
	}
	if ($styleendrange == ""){
		unset($Transmarco["queryend"]);
	}
	if ($desc == ""){
		unset($Transmarco["querydesc"]);
	}
	if ($syear == "") {
		unset($Transmarco["queryyear"]);
	}
	############################################################
	# Formatting the Session ID string that controls the Query #
	############################################################
	if ($group != ""){
		$Transmarco["querygroup"] = $group;
		// Group is defined by user
		$Transmarco["querysql"] = $Transmarco["querysql"] . "where invgroupcode='$group'";
		if ($supplier != "") {
			// Group is defined, Supplier is defined
			$Transmarco["querysupplier"] = $supplier;
			$Transmarco["querysql"] = $Transmarco["querysql"] . " and invsupplier='$supplier'";
		}
	} else {
		// Group is not defined; Supplier is defined
		if ($supplier != "") {
			$Transmarco["querysupplier"] = $supplier;
			$Transmarco["querysql"] = $Transmarco["querysql"] . "where invsupplier='$supplier'";
		} else {
			// Neither Group nor Supplier is defined; Do nothing
		}
	}
	if ($ref != "") {
		// User specified to search by reference
		$Transmarco["queryref"] = $ref;
		if ($Transmarco["querysql"] == "select * from inventoryprofile "){
			// No search parameters input yet
			$Transmarco["querysql"] = $Transmarco["querysql"] . "where invrefno='$ref'";
		}
		if ($Transmarco["querysql"] != "select * from inventoryprofile "){
			// Other parameters already present and therefore "where" in the sql string is no longer needed
			$Transmarco["querysql"] = $Transmarco["querysql"] . " and invrefno='$ref'";
		}
	}
	if ($stylestartingrange != "") {
		// Dumb way of appending leading zeros
		if (strlen($stylestartingrange) == 1) {
			$stylestartingrange = "000" . $stylestartingrange;
		}
		if (strlen($stylestartingrange) == 2) {
			$stylestartingrange = "00" . $stylestartingrange;
		}
		if (strlen($groupnumbernow) == 3) {
			$stylestartingrange = "0" . $stylestartingrange;
		}
		// User specified to search by starting range
		$Transmarco["querystart"] = $stylestartingrange;
		if ($Transmarco["querysql"] == "select * from inventoryprofile "){
			// No search parameters input yet
			$Transmarco["querysql"] = $Transmarco["querysql"] . "where invnumber>='$stylestartingrange'";
		}
		if ($Transmarco["querysql"] != "select * from inventoryprofile "){
			// Other parameters already present and therefore "where" in the sql string is no longer needed
			$Transmarco["querysql"] = $Transmarco["querysql"] . " and invnumber>='$stylestartingrange'";
		}
	}
	if ($styleendrange != "") {
		// Dumb way of appending leading zeros
		if (strlen($styleendrange) == 1) {
			$styleendrange = "000" . $styleendrange;
		}
		if (strlen($stylestartingrange) == 2) {
			$styleendrange = "00" . $styleendrange;
		}
		if (strlen($groupnumbernow) == 3) {
			$styleendrange = "0" . $styleendrange;
		}
		// User specified to search by ending range
		$Transmarco["queryend"] = $styleendrange;
		if ($Transmarco["querysql"] == "select * from inventoryprofile "){
			// No search parameters input yet
			$Transmarco["querysql"] = $Transmarco["querysql"] . "where invnumber<='$styleendrange'";
		}
		if ($Transmarco["querysql"] != "select * from inventoryprofile "){
			// Other parameters already present and therefore "where" in the sql string is no longer needed
			$Transmarco["querysql"] = $Transmarco["querysql"] . " and invnumber<='$styleendrange'";
		}
	}
	if ($desc != "") {
		// User specified to search by description
		$Transmarco["querydesc"] = stripslashes(magiccode($desc));
		if ($Transmarco["querysql"] == "select * from inventoryprofile "){
			// No search parameters input yet
			$Transmarco["querysql"] = $Transmarco["querysql"] . "where invdesc like '%$desc%'";
		}
		if ($Transmarco["querysql"] != "select * from inventoryprofile "){
			// Other parameters already present and therefore "where" in the sql string is no longer needed
			$Transmarco["querysql"] = $Transmarco["querysql"] . " and invdesc like '%$desc%'";
		}
	}
	if ($syear != "") {
		$year = $syear;
		if ($quarter != "") {
			if ($quarter == "q1"){
				$Transmarco["querymsg"] = "All Inventory Profiles Created in Quarter One<br>";
				if ($Transmarco["querysql"] == "select * from inventoryprofile ") {
					$Transmarco["querysql"] = $Transmarco["querysql"] . "where invcreatedtime>='$year-01-01'" . "and invcreatedtime<='$year-03-31'";
				}
				else {
					$Transmarco["querysql"] = $Transmarco["querysql"] . " and invcreatedtime>='$year-01-01'" . "and invcreatedtime<='$year-03-31'";
				}
			}
			else if ($quarter == "q2"){
				$Transmarco["querymsg"] = "All Inventory Profiles Created in Quarter Two<br>";
				if ($Transmarco["querysql"] == "select * from inventoryprofile ") {
					$Transmarco["querysql"] = $Transmarco["querysql"] . "where invcreatedtime>='$year-04-01'" . "and invcreatedtime<='$year-06-30'";
				}
				else {
					$Transmarco["querysql"] = $Transmarco["querysql"] . " and invcreatedtime>='$year-04-01'" . "and invcreatedtime<='$year-06-30'";
				}
			}
			else if ($quarter == "q3"){
				$Transmarco["querymsg"] = "All Inventory Profiles Created in Quarter Three<br>";
				if ($Transmarco["querysql"] == "select * from inventoryprofile ") {
					$Transmarco["querysql"] = $Transmarco["querysql"] . "where invcreatedtime>='$year-07-01'" . "and invcreatedtime<='$year-09-30'";
				}
				else {
					$Transmarco["querysql"] = $Transmarco["querysql"] . " and invcreatedtime>='$year-07-01'" . "and invcreatedtime<='$year-09-30'";
				}
			}
			else if ($quarter == "q4"){
				$Transmarco["querymsg"] = "All Inventory Profiles Created in Quarter Four<br>";
				if ($Transmarco["querysql"] == "select * from inventoryprofile ") {
					$Transmarco["querysql"] = $Transmarco["querysql"] . "where invcreatedtime>='$year-10-01'" . "and invcreatedtime<='$year-12-31'";
				}
				else {
					$Transmarco["querysql"] = $Transmarco["querysql"] . " and invcreatedtime>='$year-10-01'" . "and invcreatedtime<='$year-12-31'";
				}
			}
		}
		else {
			if ($Transmarco["querysql"] == "select * from inventoryprofile ") {
				$Transmarco["querysql"] = $Transmarco["querysql"] . "where substring(invcreatedtime, 1, 4) = '$year'";
			}
			else {
				$Transmarco["querysql"] = $Transmarco["querysql"] . " and substring(invcreatedtime, 1, 4) = '$year'";
			}
		}
	}	
	else {
		if ($quarter != "") {
			if ($quarter == "q1"){
				$Transmarco["querymsg"] = "All Inventory Profiles Created in Quarter One<br>";
				if ($Transmarco["querysql"] == "select * from inventoryprofile ") {
					$Transmarco["querysql"] = $Transmarco["querysql"] . "where substring(invcreatedtime, 6, 10)>='01-01' and substring(invcreatedtime, 6, 10)<='03-31'";
				}
				else {
					$Transmarco["querysql"] = $Transmarco["querysql"] . " and substring(invcreatedtime, 6, 10)>='01-01' and substring(invcreatedtime, 6, 10)<='03-31'";
				}
			}
			else if ($quarter == "q2"){
				$Transmarco["querymsg"] = "All Inventory Profiles Created in Quarter Two<br>";
				if ($Transmarco["querysql"] == "select * from inventoryprofile ") {
					$Transmarco["querysql"] = $Transmarco["querysql"] . "where substring(invcreatedtime, 6, 10)>='04-01' and substring(invcreatedtime, 6, 10)<='06-30'";
				}
				else {
					$Transmarco["querysql"] = $Transmarco["querysql"] . " and substring(invcreatedtime, 6, 10)>='04-01' and substring(invcreatedtime, 6, 10)<='06-30'";
				}
			}
			else if ($quarter == "q3"){
				$Transmarco["querymsg"] = "All Inventory Profiles Created in Quarter Three<br>";
				if ($Transmarco["querysql"] == "select * from inventoryprofile ") {
					$Transmarco["querysql"] = $Transmarco["querysql"] . "where substring(invcreatedtime, 6, 10)>='07-01' and substring(invcreatedtime, 6, 10)<='09-30'";
				}
				else {
					$Transmarco["querysql"] = $Transmarco["querysql"] . " and substring(invcreatedtime, 6, 10)>='07-01' and substring(invcreatedtime, 6, 10)<='09-30'";
				}
			}
			else if ($quarter == "q4"){
				$Transmarco["querymsg"] = "All Inventory Profiles Created in Quarter Four<br>";
				if ($Transmarco["querysql"] == "select * from inventoryprofile ") {
					$Transmarco["querysql"] = $Transmarco["querysql"] . "where substring(invcreatedtime, 6, 10)>='10-01' and substring(invcreatedtime, 6, 10)<='12-31'";
				}
				else {
					$Transmarco["querysql"] = $Transmarco["querysql"] . " and substring(invcreatedtime, 6, 10)>='10-01' and substring(invcreatedtime, 6, 10)<='12-31'";
				}
			}
		}
	}	
}
##############################
# Parsing of Top Query Table #
##############################
if ($Transmarco["accesslevel"] < $public) {
	authfail();
} else 	{
##################################################################
# Registering the users' preference to hide the top query screen #
##################################################################
if ($action == "HideTop"){
	$Transmarco["querysettings"]="HideTop";
}
if ($action == "ShowAll"){
	$Transmarco["querysettings"]="ShowAll";
}
#########################
# Upload Image Processes#
#########################
if ($action == "UploadFile") {
	//validate upload
	if ($imgfile == "none") {
		$error=1;
		$errmsg.= "Please browse for a file before uploading.<br>";	
	}
	else {
		$maxwidth = "320";
		$maxheight = "320";
		$imghw = GetImageSize($imgfile);
		$imgwidth = $imghw[0];
		$imgheight = $imghw[1];
		$imgorig = $imgwidth;
		if($imgwidth > $maxwidth){
			$error=1;
			$errmsg.="Your image should be no wider than " . $maxwidth . " pixels.<br>";
		}
		if($imgheight > $maxheight){
			$error=1;
			$errmsg.="Your image should be no higher than " . $maxheight . " pixels.<br>";
		}
		if ($imgfile_size > 100000) {
			$error=1;
			$errmsg.= "Your image file size should not exceed 100KB.<br>";
		}
	}
	if ($error!=1) {
		$sql = "select * from inventoryprofile where invid=$invid";
		$result = db_query($sql);
		$row = db_fetch_array($result,1);		
		$currentinvgroupcode = $row["invgroupcode"];
		$currentinvnumber = $row["invnumber"];
		# Combining var group and no to var currentmodel
		$currentmodel = $currentinvgroupcode . $currentinvnumber;
		$imgfilename = magiccode($imgfile_name);
		# Find the suffix (following the dot) for the filename and place it in the array $suffixes
		ereg("\....", $imgfilename, $suffixes);
		# Get the suffix from the array
		$suffix = $suffixes[0];
		# Create a new numerical filename by concatenating the date and the original suffix 
		$newname =  $currentmodel . "$suffix";
		if ($suffix == ".jpg") {
			# Copying/Upload the file from local machine to server 
			copy($imgfile,"$catalog" . "$newname");
			$sql = "update inventoryprofile set invimg='$newname' where invid=$invid";
			db_query($sql);
			$errmsg.= "Upload Successful!";
		} else {
			$errmsg.= "Invalid File Type Specified.<br>Valid files for uploading are as follows: .jpg<br><br>";
		}
	} else {
		$errmsg.= "Upload Failed<br>";
	}
}
?>
<html>
<head>
<title>inventory query/update</title>
<script language="JavaScript">
<!--
function Pop(theURL,winName,features) { //v2.0
window.open(theURL,winName,features);
}
//-->
</script>
<? include($style); ?>
</head>
<body bgcolor=#ffffff leftmargin="0" topmargin="0" marginwidth="0" marginheight="0">
<table width="540" border="0" cellspacing="0" cellpadding="8" align="center">
<tr valign="top"> 
	<td align="center">
		<? if ($Transmarco["querysettings"]=="ShowAll") {?>
		<font class="sub"><b><a href="<?=$docroot?>/<? echo $prodquery . "?action=HideTop" ?>">Hide Query Form</a></b></font>
		<? } else { ?>
		<font class="sub"><b><a href="<?=$docroot?>/<? echo $prodquery . "?action=ShowAll" ?>">Show Query Form</a></b></font>
		<? } ?></td>
</tr>
</table>
<? if ($Transmarco["querysettings"]=="ShowAll"){ ?>
<form method="post" action="<?=$PHP_SELF?>" name="form">
<table class="bigbox" width="540" border="0" cellspacing="0" cellpadding="0" align="center">
<tr>
	<td width="16" height="16" valign="top" align="left"><img src="<?=$images?>a.gif" width="16" height="18"></td>
	<td width="363"><img src="<?=$images?>shim.gif" width="16" height="16"></td>
	<td width="17" height="16" align="right" valign="top"><img src="<?=$images?>b.gif" width="16" height="16"></td>
</tr>
<tr>
	<td width="16">&nbsp;</td>
	<td valign="top">
	<p>The search criteria below may be used in any particular combination to produce the inventory results list.<br></p>
		<table width="100%" border="0" cellspacing="0" cellpadding="2">
		<tr valign="baseline"> 
			<td width="15%"><b>Group:</b></td>
			<td width="15%"> 
				<select name="group">
				<OPTION selected value ="">Select All
				<? 
				$sql = "select * from grouptable where groupactive='Y' order by groupcode";
				$result= db_query($sql);
				for ($x = 0;$x < db_numrows($result);$x++) {
					$row = db_fetch_array($result,$x);
					$groupid[$x] = $row["groupid"]; 
					$groupcode[$x] = $row["groupcode"];
				?>
				<OPTION value = "<?=$groupcode[$x]?>" <?if ( isset($Transmarco["querygroup"]) && $Transmarco["querygroup"]==$groupcode[$x]) echo "selected"; ?>>
				<?=$groupcode[$x]?>
				<? } ?>
				</select></td>
			<td width="5%">&nbsp;</td>
			<td width="20%"><b>Style Range:</b></td>
			<td width="40%"><input type="text" name="stylestartingrange" size="10" value="<?=$Transmarco["querystart"]?>"><b>starting</b></td>
		</tr>
		<tr valign="baseline"> 
			<td width="15%"><b>Supplier:</b></td>
			<td width="15%">
				<select name="supplier">
				<OPTION selected value ="">Select All
				<? 
				$sql = "select * from supplier where supplierstatus='Y' order by suppliername";
				$result= db_query($sql);
				for ($x = 0;$x < db_numrows($result);$x++) {
					$row = db_fetch_array($result,$x);
					$supplierid[$x] = $row["supplierid"]; 
					$suppliername[$x] = $row["suppliername"];
				?>
				<OPTION value = "<?=$suppliername[$x]?>" <?if ( isset($Transmarco["querysupplier"]) && $Transmarco["querysupplier"]==$suppliername[$x]) echo "selected"; ?>>
				<?=$suppliername[$x]?>
				<? } ?>
				</select></td>
			<td width="5%">&nbsp;</td>
			<td width="20%">&nbsp;</td>
			<td width="40%"> 
				<input type="text" name="styleendrange" size="10" value="<?=$Transmarco["queryend"]?>"><b>end</b></td>
		</tr>
		<tr valign="baseline"> 
			<td width="15%"><b>Reference:</b></td>
			<td width="15%"><input type="text" name="ref" size="10" value="<? if (isset($Transmarco["queryref"])) echo $Transmarco["queryref"]; ?>"></td>
			<td width="5%">&nbsp;</td>
			<td width="18%"><b>Description:</b></td>
			<td width="40%"><input type="text" name="desc" size="20" maxlength="20" value="<?=$Transmarco["querydesc"]?>"></td>
		</tr>
		<tr valign="baseline"> 
			<td width="15%">&nbsp;</td>
			<td width="15%">&nbsp;</td>
			<td width="5%">&nbsp;</td>
			<td width="18%"><b>Date Range:</b></td>
			<td width="40%">
				<select name="syear">
				<option selected value ="">All</option>
				<?
				$sql = "select distinct substring(invcreatedtime, 1, 4) from inventoryprofile order by invcreatedtime";
				$result = db_query($sql);
				for ($x = 0;$x < db_numrows($result);$x++) {
					$row = db_fetch_array($result,$x);
					$years[$x] = $row[0];
				?>
				<option value="<?=$row[0]?>" 
				<? if (isset($Transmarco["queryyear"]) && $Transmarco["queryyear"] == $years[$x]) echo "selected";?>>
				<?=$row[0]?></option>
				<? } ?>
				</select><b>year</b>&nbsp;&nbsp;
				<select name="quarter">
				<option selected value="">All</option>
				<option value="q1">1st</option>
				<option value="q2">2nd</option>
				<option value="q3">3rd</option>
				<option value="q4">4th</option>
				</select><b>quarter</b></td>
		</tr>
		<tr valign="baseline"> 
			<td colspan="5"><input type="submit" name="action" value="Query">&nbsp;&nbsp;<input type="submit" name="action" value="Reset"></td>
		</tr>
		</table></td>
	<td width="17" align="right">&nbsp;</td>
</tr>
<tr> 
	<td width="16" valign="bottom" align="left"><img src="<?=$images?>c.gif" width="16" height="18"></td>
	<td width="363">&nbsp;</td>
	<td width="17" align="right" valign="bottom"><img src="<?=$images?>d.gif" width="16" height="16"></td>
</tr>
</table>
<p><input type="hidden" name="error" value="<?=$error?>"></p>
</form>
<? } ?>
<table width="680" border="0" cellspacing="0" cellpadding="8" align="center">
<tr valign="top"> 
	<td align="center">
		<font class="sub"><b>UPDATE INVENTORY PROFILE</b><br>
		<b><? echo $Transmarco["querymsg"] . "<p>";?></b></font></td>
</tr>
</table>
<table class="bigbox" border="0" cellspacing="0" cellpadding="0" align="center" width="100%">
<tr> 
	<td width="16" height="16" valign="top" align="left"><img src="<?=$images?>a.gif" width="16" height="18"></td>
	<td width="363"><img src="<?=$images?>shim.gif" width="16" height="16"></td>
	<td width="17" height="16" align="right" valign="top"><img src="<?=$images?>b.gif" width="16" height="16"></td>
</tr>
<tr> 
	<td width="16">&nbsp;</td>
	<td valign="top" class="bgline"> 
		<table cellpadding="3" cellspacing="1" border="0" align="center" width="100%">
		<tr class="highlights" align="center" valign="baseline"> 
			<td width="5%"><a href="<?=$docroot?>/<? echo $prodquery . "?sortorder=Date_Created" ?>"><b>Date<br>(dd-mm-yyyy)</b></a></td>
			<td width="5%"><a href="<?=$docroot?>/<? echo $prodquery . "?sortorder=Model" ?>"><b>Model</b></a></td>
			<td width="2%"><b>i</b></td>
			<td width="16%"><b>Description</b></td>
			<td width="10%"><b>Colour<br>Range</b></td>
			<td width="8%"><b>Size<br>Range</b></td>
			<td width="8%"><a href="<?=$docroot?>/<? echo $prodquery . "?sortorder=Supplier" ?>"><b>Supplier</b></a></td>
			<td width="5%"><b>Cost</b></td>
			<td width="9%"><a href="<?=$docroot?>/<? echo $prodquery . "?sortorder=Ref_No" ?>"><b>Delivery Date<br>(Ref No)</b></a></td>
			<td width="6%"><b>Qty</b></td>
			<td width="5%"><b>Retail<br>Price</b></td>
			<td width="5%"><a href="<?=$docroot?>/<? echo $prodquery . "?sortorder=Created_By" ?>"><b>Created <br>by</b></a></td>
			<td width="12%"><b>Remarks</b></td>
			<td width="6%"><b>Action</b></td>
		</tr>
		<?					
		$result = db_query($Transmarco["querysql"] . $Transmarco["userquerysort"]);
		for ($x = 0;$x < db_numrows($result);$x++) {
			$row = db_fetch_array($result,$x);
			$currentinvid = $row["invid"];
			$currentinvgroupcode = $row["invgroupcode"];
			$currentinvnumber = $row["invnumber"];
			$currentinvdesc = $row["invdesc"];
			$currentinvsizerange = $row["invsizerange"];
			$currentinvsupplier = $row["invsupplier"];
			$currentinvcost = $row["invcost"];
			$currentinvdeliverydatetime = $row["invdeliverydatetime"];
			$currentinvrefno = $row["invrefno"];
			$currentinvqty = $row["invqty"];
			$currentinvretailprice = $row["invretailprice"];
			$currentinvcreatedbyuser = ucwords($row["invcreatedbyuser"]);
			$currentinvremarks = $row["invremarks"];
			$currentinvimg = $row["invimg"];
			$currentinvlock = $row["invlock"];
			$currentinvedit = $row["invedit"];
			# Combining var group and no to var currentmodel
			$currentmodel = $currentinvgroupcode . $currentinvnumber;
			# Fix Netscape display problem
			if ($currentinvdesc=="") {
				$currentinvdesc = "&nbsp;";
			}
			if ($currentinvsizerange=="") {
				$currentinvsizerange = "&nbsp;";
			}
			if ($currentinvsupplier=="") {
				$currentinvsupplier = "&nbsp;";
			}
			if ($currentinvcost=="") {
				$currentinvcost = "&nbsp;";
			}
			if ($currentinvretailprice=="") {
				$currentinvretailprice = "&nbsp;";
			}
			if ($currentinvremarks=="") {
				$currentinvremarks = "&nbsp;";
			}
			if ($currentinvdeliverydatetime == "0000-00-00 00:00:00") {
				$currentinvdeliverydatetime = "NA";
			} else {
				ereg ("([0-9]{1,4})-([0-9]{1,2})-([0-9]{1,2})", $row["invdeliverydatetime"], $deldate);
				$currentinvdeliverydatetime = $deldate[3]."-".$deldate[2]."-".$deldate[1];
			}
			# Formatting inventory created time into a useful string
			ereg ("([0-9]{1,4})-([0-9]{1,2})-([0-9]{1,2})", $row["invcreatedtime"], $regs);
			$currentinvcreatedtime = $regs[3]."-".$regs[2]."-".$regs[1];
			$currentcreatedyear = $regs[1];
			$availablecolours = "&nbsp;";
			$sqlcolourdisplay = "select * from colourinv where invid='$currentinvid'";
			$resultcolourdisplay = db_query($sqlcolourdisplay);
			for ($y = 0;$y < db_numrows($resultcolourdisplay);$y++) {
				$rowcolourdisplay = db_fetch_array($resultcolourdisplay,$y);
				$currentcolourname = $rowcolourdisplay["colourname"];
				$availablecolours = $availablecolours . $currentcolourname . " ";
			}
		?>
		<tr class="tdfill" align="center" valign="baseline"> 
			<td width="5%"><?=$currentinvcreatedtime?></td>
			<td width="5%">
			<?
			if ($currentinvimg == "") {
				echo $currentmodel;
			} else { ?>
				<a href=# onClick="Pop('<?=$docroot?>/<?=$prodview?>?action=Edit&id=<?=$currentinvid?>','Catalog','scrollbars=0,menubar=0,toolbar=0,location=0,status=0,resizable=0,width=480,height=480')"><?=$currentmodel?></a>
			<?
			}?></td>
			<td width="2%">
			<? if ($currentinvlock == 'N') { ?>
				<a href="<?=$docroot?>/<?=$prodquery?>?action=Upload&invid=<?=$currentinvid?>"><img src="<?=$images?>up.gif" alt="Click on icon to upload image" border=0></a>
			<? } else { ?>
				<img src="<?=$images?>lup.gif" alt="Image upload disabled" border=0>
			<? } ?></td>
			<td width="16%"><?=$currentinvdesc?></td>
			<td width="10%"><?=$availablecolours?></td>
			<td width="8%"><?=$currentinvsizerange?></td>
			<td width="8%"><?=$currentinvsupplier?></td>
			<td width="5%"><?=$currentinvcost?></td>
			<td width="9%"><?=$currentinvdeliverydatetime?><br><? echo "Ref No :" . $currentinvrefno; ?></td>
			<td width="6%"><?=$currentinvqty?></td>
			<td width="7%"><?=$currentinvretailprice?></td>
			<td width="5%"><?=$currentinvcreatedbyuser?></td>
			<td width="12%"><?=$currentinvremarks?></td>
			<td width="6%">
			<?
			if ($currentinvlock == 'N') { ?>
				<a href="<?=$docroot?>/<?=$prodquery?>?action=Edit&id=<?=$currentinvid?>"><img src="<?=$images?>edit.gif" alt="Edit" border=0></a>
			<?
			} else {
				echo "";
			}
			if ($Transmarco["accesslevel"] == $adminlevel ) {
				if ($currentinvlock == 'N') { ?>
					<a href="<?=$docroot?>/<?=$prodquery?>?action=Lock&id=<?=$currentinvid?>"><img src="<?=$images?>unlock.gif" alt="Click on icon to Lock" border=0></a>
			<?
				} else { ?>
					<a href="<?=$docroot?>/<?=$prodquery?>?action=Unlock&id=<?=$currentinvid?>"><img src="<?=$images?>lock.gif" alt="Click on icon to Unlock" border=0></a>
			<?
				}
			}?></td>
		</tr>
		<?
		} ?>
		</table></td>
	<td width="16" align="right">&nbsp;</td>
</tr>
<tr> 
	<td width="16" valign="bottom" align="left"><img src="<?=$images?>c.gif" width="16" height="18"></td>
	<td width="363">&nbsp;</td>
	<td width="17" align="right" valign="bottom"><img src="<?=$images?>d.gif" width="16" height="16"></td>
</tr>
</table>
<p>
<?
if ($action == "Edit" || $action == "Update") { ?>
<center><b><? echo $msg . "<p>" ?></b></center>
<form method="post" action="<?=$PHP_SELF?>" name="form">
<table class ="bigbox" border="0" cellspacing="0" cellpadding="0" align="center">
<tr> 
	<td width="16" height="16" valign="top" align="left"><img src="<?=$images?>a.gif" width="16" height="18"></td>
	<td width="763"><img src="<?=$images?>shim.gif" width="16" height="16"></td>
	<td width="17" height="16" align="right" valign="top"><img src="<?=$images?>b.gif" width="16" height="16"></td>
</tr>
<tr> 
	<td width="16">&nbsp;</td>
	<td class="bgline" valign="top" width="763">
		<table cellpadding="5" width="763" cellspacing="1" border="0" align="center">
		<? 
		$sql = "select * from inventoryprofile where invid='$id'";
		$result = db_query($sql);
		$row = db_fetch_array($result,$x);
		# Getting the inventory ID for colour matching
		$currentinvid = $row["invid"];
		# Formatting inventory created time into a useful string
		ereg ("([0-9]{1,4})-([0-9]{1,2})-([0-9]{1,2})", $row["invcreatedtime"], $regs);
		$currentinvcreatedtime = $regs[3]."-".$regs[2]."-".$regs[1];
		if ($row["invdeliverydatetime"] == "0000-00-00 00:00:00") {
			$deldate[3] = $today['mday'];
			$deldate[2] = $today['mon'];
			$deldate[1] = $today['year'];
		} else {
			ereg ("([0-9]{1,4})-([0-9]{1,2})-([0-9]{1,2})", $row["invdeliverydatetime"], $deldate);
			$currentinvdeliverydatetime = $deldate[3]."-".$deldate[2]."-".$deldate[1];
		}
		?>
		<tr class="highlights">
			<td width="75%" align="left"><? echo "<b>Model Number : " . $row["invgroupcode"] . $row["invnumber"] . "</b>" . "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Date Created : " . $currentinvcreatedtime ?></td>
			<td width="25%" align="right"><? echo "Created By : " . ucwords($row["invcreatedbyuser"])?></td>
		</tr>
		</table>
		<table cellpadding="3" width="763" cellspacing="1" border="0" align="center">
		<tr class="highlights">
			<td width="25%">Inventory Profile Description</td>
			<td width="75%"><input type="text" name="invdesc" value="<?=$row["invdesc"]?>" maxlength="200" size="65"></td>
		</tr>
		<tr class="highlights">
			<td width="25%">Available Colors</td>
			<td width="75%"><select multiple size="3" name="invcolor[]">
			<?
			$sqlcolour = "select * from colour where colourstatus='Y' order by colourname";
			$resultcolour = db_query($sqlcolour);
			for ($x = 0;$x < db_numrows($resultcolour);$x++) {
				$rowcolour = db_fetch_array($resultcolour,$x);
				$colourname = $rowcolour["colourname"];
				# Checking to see if this colour exists for this inventory profile
				$sqlcolourselect = "select * from colourinv where colourname='$colourname' and invid='$currentinvid'";
				$resultcolourselect = db_query($sqlcolourselect);
				$thiscolour = "";
				if (db_numrows($resultcolourselect) > 0){
					$thiscolour = "selected ";
				}
			?>
				<option <?=$thiscolour?> value=<?=$rowcolour["colourname"]?>><?=$rowcolour["colourname"]?>
			<?
			} ?>
			</select>* Use Shift to block a colour range or Control to select colours manually</td>
		</tr>
  		<tr class="highlights">
			<td width="25%">Size Range</td>
			<td width="75%"><input type="text" name="invsizerange" value='<?=$row["invsizerange"]?>' maxlength="20" size="20"> *Mandatory Field</td>
		</tr>
		<tr class="highlights">
			<td width="25%">Supplier</td>
			<td width="75%"><select name="supplier">
				<OPTION selected value ="">Select One
				<? 
				$sqlsupplier = "select * from supplier where supplierstatus='Y' order by suppliername";
				$resultsupplier= db_query($sqlsupplier);
				for ($x = 0;$x < db_numrows($resultsupplier);$x++) {
					$rowsupplier = db_fetch_array($resultsupplier,$x);
					$suppliername[$x] = $rowsupplier["suppliername"];
				?>
				<OPTION value = "<?=$suppliername[$x]?>" <? if (isset($row["invsupplier"]) && $row["invsupplier"]==$suppliername[$x]) echo "selected";?>><?=$suppliername[$x]?>
				<?
				} ?>
				</select> *Mandatory Field</td>
		</tr>
		<tr class="highlights">
			<td width="25%">Cost</td>
			<td width="75%"><input type="text" name="invcost" value="<?=$row["invcost"]?>" maxlength="20" size="20"> *Mandatory Field</td>
		</tr>
		<tr class="highlights">
			<td width="25%">Delivery Date</td><? $regs[3]."-".$regs[2]."-".$regs[1] ?>
			<td width="75%"><input type="text" name="invdeliveryday" value="<?=$deldate[3]?>" maxlength="2" size="2"><input type="text" name="invdeliverymonth" value="<? echo $deldate[2] ?>" maxlength="2" size="2"><input type="text" name="invdeliveryyear" value="<? echo $deldate[1] ?>" maxlength="4" size="4"> *dd-mm-yyyy Default Date Entered = Today</td>
		</tr>
		<tr class="highlights">
			<td width="25%">Quantity</td>
			<td width="75%"><input type="text" name="invqty" value="<?=$row["invqty"]?>" maxlength="5" size="5"> *Mandatory Field</td>
		</tr>
		<tr class="highlights">
			<td width="25%">Retail Price</td>
			<td width="75%"><input type="text" name="invretailprice" value="<?=$row["invretailprice"]?>" maxlength="24" size="10"> *Mandatory Field</td>
		</tr>
		<tr class="highlights">
			<td width="25%">Remarks</td>
			<td width="75%"><input type="text" name="invremarks" value="<?=$row["invremarks"]?>" maxlength="200" size="65"></td>
		</tr>
		<tr class="highlights" valign="baseline"> 
			<td align="center" colspan="2"><input type="submit" name="action" value="Update">&nbsp;<input type="reset" name="Reset" value="Clear">&nbsp<input type="submit" name="action" value="Cancel"></td>
		</tr>
		<input type="hidden" name="id" value="<?=$row["invid"]?>">
		</table></td>
	<td width="17">&nbsp;</td>
</tr>
<tr> 
	<td width="16" valign="bottom" align="left"><img src="<?=$images?>c.gif" width="16" height="18"></td>
	<td width="763">&nbsp;</td>
	<td width="17" align="right" valign="bottom"><img src="<?=$images?>d.gif" width="16" height="16"></td>
</tr>
</table>
</form>
<p>
<?
}
if ($action == "Upload" || $action == "UploadFile") {
	$sql = "select * from inventoryprofile where invid=$invid";
	$result = db_query($sql);
	for ($x = 0;$x < db_numrows($result);$x++) {
		$row = db_fetch_array($result,1);
	}
?>
<center><b><? echo $msg . "<p>" ?></b></center>
<form enctype="multipart/form-data" name="form" action="<?=$PHP_SELF?>" method="post">
<table width="360" border="0" cellspacing="0" cellpadding="8" align="center">
<tr valign="top"><td><font class="sub"><b>Upload Image</b></font></td></tr>
</table>
<table class="bigbox" border="0" cellspacing="0" cellpadding="0" align="center" width="360">
<tr>
	<td width="16" height="16" valign="top" align="left"><img src="<?=$images?>a.gif" width="16" height="18"></td>
	<td width="363"><img src="<?=$images?>shim.gif" width="16" height="16"></td>
	<td width="17" height="16" align="right" valign="top"><img src="<?=$images?>b.gif" width="16" height="16"></td>
</tr>
<tr> 
	<td width="16">&nbsp;</td>
	<td valign="top" class="bgline"> 
		<table cellpadding="5" cellspacing="1" border="0" align="center" width="100%">
		<tr>
			<td height="39" class="highlights">Click <b>Browse</b> and select a file to upload<br>
			<b>NOTE:</b> Max uploaded file size is 100KB. File extension must be in *.jpg.</td>
		</tr>
		<tr> 
			<td height="39" class="highlights">
				<input type="hidden" name="max_file_size" value=100000>
				<input type="hidden" name="invid" value=<?=$invid?>>
				<input type="file" name="imgfile" size="30"></td>
		</tr>
		<tr>
			<td height="39" class="highlights">
				<input type="submit" name="action" value="UploadFile">
				<p> 
				<? if(isset($errmsg)) echo $errmsg; ?></td>
		</tr>
		</table></td>
	<td width="17" align="right">&nbsp;</td>
</tr>
<tr> 
	<td width="16" valign="bottom" align="left"><img src="<?=$images?>c.gif" width="16" height="18"></td>
	<td width="363">&nbsp;</td>
	<td width="17" align="right" valign="bottom"><img src="<?=$images?>d.gif" width="16" height="16"></td>
</tr>
</table>
</form>
<? 
} ?>
</body>
</html>
<?
} ?>