<?
/*
Author		: Yaw
Version		: 1.01
Date			: 29th March 2002
Function		: Colour Management
*/ 

session_start();
require("auth.php");
unset($msg);

######################################################
# Determine if Access Level is adequate to view page #
######################################################
if ($Transmarco["accesslevel"]<$adminlevel) {
	authfail();
} else 	{ 

#######################################################################
# Registering Sort Order into Session                                 #
# Will control the page so that the page appears in the same sorting  #
# order everytime the user from the same browser access the same page #
#######################################################################
// First time the user access the page, automatically sort by group starting range
if (($Transmarco["usercoloursort"] == "") && ($sortorder == "")) {
	$Transmarco["usercoloursort"] = "colourname";
}
// Subsequently when users decide on a sorting preference, store their preference into a session
if (($Transmarco["usercoloursort"] != "") && ($sortorder != "")) {
	$Transmarco["usercoloursort"] = $sortorder;
}

###################################################
# Deactivate a colour                           #
# Updating database if user decides to Deactivate #
###################################################
if ($action == 'Deactivate') {
	$sql = "update colour set colourstatus='N' where colourid=$id";
	db_query($sql);
	$msg = "Colour Deactivated<br>";
}

#################################################
# Activating a colour                         #
# Updating database if user decides to Activate #
#################################################
if ($action == 'Activate') {
	$sql = "update colour set colourstatus='Y' where colourid=$id";
	db_query($sql);
	$msg = "Colour Activated<br>";
}

###################################################
# Editing a colour                              #
# Inserting into database if user decides to Edit #
###################################################
if (($action == 'Edit') && ($submitted == 'yes')) {
	// Initializing Msg Text
	$msg = "";

	// Checking if Group Description is blank when User is editing a group
	if ($colourdesc != "") {
		$colourdesc = magiccode(ucwords($colourdesc));
		$sql = "update colour set colourdesc='$colourdesc' where colourid=$id";
		$result = db_query($sql);
		$msg = "Colour Description Successfully Updated!";
	} else {
		$msg = "Colour Description Must Be Filled In";
	}
}

##################################################
# Add a colour                                 #
# Inserting into database if user decides to Add #
##################################################
if (($action == 'Add') && ($submitted == 'yes')) {
	// Initializing Msg Text
	$msg = "";

	// Checking if colour name is valid when User is adding a colour, and if valid, force all characters to uppercase
	if ($colourname != "") {
		// Checking to see the the existing Group Code already exists in the database
		$colourname = magiccode(strtoupper($colourname));
		$sql = "select * from colour where colourname='$colourname'";
		$result = db_query($sql);
		if (db_numrows($result) >= 1) {
			$msg = $msg . "The colour name keyed in already exists in the database!<br>";
		}
	} else {
		$msg = $msg . "Invalid colour Name Entered<br>";
	}

	// Checking if colour Description is valid when User is adding a colour
	if ($colourdesc != "") {
		$colourdesc = magiccode($colourdesc);
	} else {
		$msg = $msg . "Invalid colour Description Entered<br>";
	}

	// If no messages are stored up until this point, all data entered is valid, Proceed with insertion
	if ($msg == "") {
		$newid = magiccode(find_new_id("colourid","colour"));
		$sql = "insert into colour (`colourid`,`colourname`,`colourdesc`,`colourstatus`) values('$newid','$colourname','$colourdesc','Y')";
		db_query($sql);
		$msg = "colour " . $colourname . " Created";
		unset($colourid);
		unset($colourname);
		unset($colourdesc);
		unset($colourstatus);
	} else {
		$msg = $msg . "<br>Creation of New colour Failed!";
	}
}

###############################
# HTML FOR FIRST TABLE ON TOP #
###############################
?>
<HTML>
	<HEAD>
		<TITLE>Colour Management Form</TITLE>
		<META content="text/html; charset=windows-1252" http-equiv=Content-Type>
		<META content=en-us http-equiv=Content-Language>
		<? include($style); ?>
	</HEAD>
	<BODY bgColor=#ffffff leftmargin="0" topmargin="0" marginwidth="0" marginheight="0">
	<center><b>EXISTING COLOUR(s)</b></center>
	<br>
	<table border="0" cellspacing="0" cellpadding="0" bgcolor="#EEEEEE" align="center">
		<tr> 
			<td width="16" height="16" valign="top" align="left"><img src="<? echo $images ?>a.gif" width="16" height="18"></td>
			<td width="763"><img src="<? echo $images ?>shim.gif" width="16" height="16"></td>
			<td width="17" height="16" align="right" valign="top"><img src="<? echo $images ?>b.gif" width="16" height="16"></td>
		</tr>
		<tr> 
			<td width="16">&nbsp</td>
			<td valign="top" bgcolor="#CCCCCC" width="763">
			<table cellpadding="5" cellspacing="1" border="0" align="center">
					<tr bgcolor="#EEEEEE">
						<td width="10%" align="left"><a href="<? echo $docroot ?>/<? echo $colourmgt ?><? echo "?sortorder=colourname"?>"><b>Colour Name</b></a></td>
						<td width="60%" align="center"><b>Colour Description</b></td>
						<td width="15%" align="left"><a href="<? echo $docroot ?>/<? echo $colourmgt ?><? echo "?sortorder=colourstatus"?>"><b>Colour Status</b></a></td>
						<td width="15%" align="right"><b>Action</b></td>
					<tr>
					<? 
					//  Generating Existing Group Codes
					$sql = "select * from colour order by $Transmarco[usercoloursort]";
					$result = db_query($sql);
					for($x = 0; $x < db_numrows($result); $x++){
						$row = db_fetch_array($result,1);
						$currentcolourid = $row["colourid"];
						$currentcolourname = $row["colourname"];
						$currentcolourdesc = $row["colourdesc"];
						$currentcolourstatus = $row["colourstatus"];

					?>
						<tr bgcolor="#FFFFFF">
							<td width="10%" align="left"><? echo $currentcolourname ?></td>
							<td width="60%" align="left"><? echo $currentcolourdesc ?></td>
							<td width="15%" align="center">
					<?
					if ($currentcolourstatus == "Y") {
					?>
							Active</td>
					<? } else { ?>
							Inactive</td>
					<? } ?>
							<td width="15%" align="right"><a href="<? echo $docroot ?>/<? echo $colourmgt ?><? echo "?action=Edit&id=" . $currentcolourid ?>">Edit</a>
					<? 
					// Generating the Activate or Deactivate action
					if ($currentcolourstatus == "Y") {				
					?>
							&nbsp<a href="<? echo $docroot ?>/<? echo $colourmgt ?><? echo "?action=Deactivate&id=" . $currentcolourid ?>"> Deactivate </a></td>
					<? } else { ?>
							&nbsp<a href="<? echo $docroot ?>/<? echo $colourmgt ?><? echo "?action=Activate&id=" . $currentcolourid ?>"> Activate </a></td>
					<? } ?>
						<tr>

					<? } ?>
				</table>
			</td>
			<td width="17">&nbsp</td>
		</tr>
		<tr> 
			<td width="16" valign="bottom" align="left">&nbsp</td>
			<td width="763">&nbsp</td>
			<td width="17" align="right" valign="bottom">&nbsp</td>
		</tr>
		<tr> 
			<td width="16" valign="bottom" align="left">&nbsp</td>
			<td width="763"><center><a href="<? echo $docroot ?>/<? echo $colourmgt ?><? echo "?action=Add" ?>">Add New Colour</center></td>
			<td width="17" align="right" valign="bottom">&nbsp</td>
		</tr>
		<tr> 
			<td width="16" valign="bottom" align="left"><img src="<? echo $images ?>c.gif" width="16" height="18"></td>
			<td width="763">&nbsp;</td>
			<td width="17" align="right" valign="bottom"><img src="<? echo $images ?>d.gif" width="16" height="16"></td>
		</tr>
	</table>

<? 	
##################################
# HTML FOR FIRST TABLE AT BOTTOM #
##################################

	if (($action == 'Edit') || ($action == 'Add')){ 
	// Prefilling the fields in the form with values from db
	if ($action=='Edit') {
		$sql = "select * from colour where colourid = $id";
		$result = db_query($sql);
		for($x=0; $x<db_numrows($result); $x++){
			$row = db_fetch_array($result,1);
			$colourid = $row["colourid"];
			$colourname = $row["colourname"];
			$colourdesc = $row["colourdesc"];
			$colourstatus = $row["colourstatus"];
		}
	}
?>
	<br><br><br>
	<center><b><? echo strtoupper($action) ?> colour</b></center>
	<br>
	<center><? echo $msg ?></center>
		<form method="post" action="<? echo $PHP_SELF ?>" name="form">
			<table width="600" border="0" cellspacing="0" cellpadding="0" bgcolor="#EEEEEE" align="center">
				<tr> 
					<td width="16" height="16" valign="top" align="left"><img src="<? echo $images ?>a.gif" width="16" height="18"></td>
					<td width="563"><img src="<? echo $images ?>shim.gif" width="16" height="16"></td>
					<td width="17" height="16" align="right" valign="top"><img src="<? echo $images ?>b.gif" width="16" height="16"></td>
				</tr>
				<tr> 
					<td width="23">&nbsp</td>
					<td width="563">
						<table>
							<tr>
								<td>Colour Name</td>
								<? if ($action == 'Add') {?>
								<td><input type="text" name="colourname" value="<? echo $colourname ?>" maxlength="20" size="20"> * The System will input this in uppercase</td>
								<? } ?>
								<? if ($action == 'Edit') {?>
								<td><? echo $colourname ?></td>
								<? } ?>
							</tr>
							<tr>
								<td>Colour Description</td>
								<td><input type="text" name="colourdesc" value="<? echo $colourdesc ?>" maxlength="200" size="65"></td>
							</tr>
						</table>
					</td>
					<td width="17">&nbsp</td>
				</tr>
				<tr valign="baseline"> 
					<td width="23">&nbsp</td>
						<input type="hidden" name="submitted" value="yes">
					<? if ($action == "Edit") { ?>
						<input type="hidden" name=id value=<? echo $id ?>>
					<? } ?>
					<td width="563"><center><input type="submit" name="action" value="<? echo ucwords($action) ?>">&nbsp<input type="reset" name="Reset" value="Clear">&nbsp<input type="submit" name="action" value="Cancel"></center></td>
					<td width="17">&nbsp</td>
				</tr>
				<tr> 
					<td width="16" valign="bottom" align="left"><img src="<? echo $images ?>c.gif" width="16" height="18"></td>
					<td width="563">&nbsp;</td>
					<td width="17" align="right" valign="bottom"><img src="<? echo $images ?>d.gif" width="16" height="16"></td>
				</tr>
			</table>
		</form>
<? } ?>
	</BODY>
</HTML>

<? } ?>
